/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ApacheConfig;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.Directive;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.DirectiveIterator;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.FileLevelContainer;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.ParserException;
import oracle.ias.sysmgmt.repository.plugin.advanced.apache.parser.PerlContainer;

public class PerlParser {
    private String perlCode;
    private File file;
    private String preCode = "package Oracle::Apache::PerlSection::PerlCode; \nuse Oracle::Apache::PerlSection(); \n";
    private String postCode = "print Oracle::Apache::PerlSection->directives('Oracle::Apache::PerlSection::PerlCode');\n";

    public PerlParser(String string) {
        this.perlCode = string;
    }

    public PerlParser(File file) {
        this.file = file;
    }

    public PerlContainer parse() throws ParserException {
        PerlContainer perlContainer = new PerlContainer(this.perlCode);
        InputStream inputStream = null;
        inputStream = this.parseToDirectives();
        ApacheConfig apacheConfig = new ApacheConfig(inputStream);
        FileLevelContainer fileLevelContainer = apacheConfig.read();
        DirectiveIterator directiveIterator = fileLevelContainer.getChildren();
        while (directiveIterator.hasNext()) {
            perlContainer.add((Directive)directiveIterator.next(), false);
        }
        return perlContainer;
    }

    private InputStream parseToDirectives() throws ParserException {
        if (this.file != null) {
            this.perlCode = this.getPerlCode(this.file);
        }
        String string = String.valueOf(this.preCode) + this.perlCode + this.postCode;
        try {
            File file = null;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.close();
            Runtime runtime = Runtime.getRuntime();
            String string2 = "perl " + file.getAbsolutePath();
            Process process = runtime.exec(string2);
            int n = process.waitFor();
            if (n != 0) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String string3 = new String();
                String string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    string3 = string3.concat(String.valueOf(string4) + "\n");
                }
                throw new ParserException(string3);
            }
            return process.getInputStream();
        }
        catch (Exception exception) {
            throw new ParserException(exception.getMessage());
        }
    }

    private String getPerlCode(File file) {
        String string = new String();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = String.valueOf(string) + string2 + "\n";
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return string;
    }

    private void printStreamContent(InputStream inputStream) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            char[] cArray = new char[4000];
            bufferedReader.read(cArray);
            String string = new String(cArray);
            System.out.println(string);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

